/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class MediaCodecListCollector {
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    private static final String[] MPEG4_TYPES = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
    private static final String[] AVC_TYPES = new String[]{"avc", "h264", "AVC", "H264"};
    private static final String[] H263_TYPES = new String[]{"h263", "H263"};
    private static final String[] AAC_TYPES = new String[]{"aac", "AAC"};
    private static Class<?> mediaCodecListClass = null;
    private static Method getCodecInfoAtMethod = null;
    private static Class<?> mediaCodecInfoClass = null;
    private static Method getNameMethod = null;
    private static Method isEncoderMethod = null;
    private static Method getSupportedTypesMethod = null;
    private static Method getCapabilitiesForTypeMethod = null;
    private static Class<?> codecCapabilitiesClass = null;
    private static Field colorFormatsField = null;
    private static Field profileLevelsField = null;
    private static Field profileField = null;
    private static Field levelField = null;
    private static SparseArray<String> mColorFormatValues = new SparseArray();
    private static SparseArray<String> mAVCLevelValues = new SparseArray();
    private static SparseArray<String> mAVCProfileValues = new SparseArray();
    private static SparseArray<String> mH263LevelValues = new SparseArray();
    private static SparseArray<String> mH263ProfileValues = new SparseArray();
    private static SparseArray<String> mMPEG4LevelValues = new SparseArray();
    private static SparseArray<String> mMPEG4ProfileValues = new SparseArray();
    private static SparseArray<String> mAACProfileValues = new SparseArray();

    public static String collecMediaCodecList() {
        StringBuilder result = new StringBuilder();
        if (mediaCodecListClass != null && mediaCodecInfoClass != null) {
            try {
                int codecCount = (Integer)mediaCodecListClass.getMethod("getCodecCount", new Class[0]).invoke(null, new Object[0]);
                Object codecInfo = null;
                for (int codecIdx = 0; codecIdx < codecCount; ++codecIdx) {
                    result.append("\n");
                    codecInfo = getCodecInfoAtMethod.invoke(null, codecIdx);
                    result.append(codecIdx).append(": ").append(getNameMethod.invoke(codecInfo, new Object[0])).append("\n");
                    result.append("isEncoder: ").append(isEncoderMethod.invoke(codecInfo, new Object[0])).append("\n");
                    Object[] supportedTypes = (String[])getSupportedTypesMethod.invoke(codecInfo, new Object[0]);
                    result.append("Supported types: ").append(Arrays.toString(supportedTypes)).append("\n");
                    for (Object type : supportedTypes) {
                        result.append(MediaCodecListCollector.collectCapabilitiesForType(codecInfo, (String)type));
                    }
                    result.append("\n");
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return result.toString();
    }

    private static String collectCapabilitiesForType(Object codecInfo, String type) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] codecProfileLevels;
        StringBuilder result = new StringBuilder();
        Object codecCapabilities = getCapabilitiesForTypeMethod.invoke(codecInfo, type);
        int[] colorFormats = (int[])colorFormatsField.get(codecCapabilities);
        if (colorFormats.length > 0) {
            result.append(type).append(" color formats:");
            for (int i = 0; i < colorFormats.length; ++i) {
                result.append((String)mColorFormatValues.get(colorFormats[i]));
                if (i >= colorFormats.length - 1) continue;
                result.append(',');
            }
            result.append("\n");
        }
        if ((codecProfileLevels = (Object[])profileLevelsField.get(codecCapabilities)).length > 0) {
            result.append(type).append(" profile levels:");
            for (int i = 0; i < codecProfileLevels.length; ++i) {
                CodecType codecType = MediaCodecListCollector.identifyCodecType(codecInfo);
                int profileValue = profileField.getInt(codecProfileLevels[i]);
                int levelValue = levelField.getInt(codecProfileLevels[i]);
                if (codecType == null) {
                    result.append(profileValue).append('-').append(levelValue);
                }
                switch (codecType) {
                    case AVC: {
                        result.append(profileValue).append((String)mAVCProfileValues.get(profileValue)).append('-').append((String)mAVCLevelValues.get(levelValue));
                        break;
                    }
                    case H263: {
                        result.append((String)mH263ProfileValues.get(profileValue)).append('-').append((String)mH263LevelValues.get(levelValue));
                        break;
                    }
                    case MPEG4: {
                        result.append((String)mMPEG4ProfileValues.get(profileValue)).append('-').append((String)mMPEG4LevelValues.get(levelValue));
                        break;
                    }
                    case AAC: {
                        result.append((String)mAACProfileValues.get(profileValue));
                        break;
                    }
                }
                if (i >= codecProfileLevels.length - 1) continue;
                result.append(',');
            }
            result.append("\n");
        }
        return result.append("\n").toString();
    }

    private static CodecType identifyCodecType(Object codecInfo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String name = (String)getNameMethod.invoke(codecInfo, new Object[0]);
        for (String token : AVC_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.AVC;
        }
        for (String token : H263_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.H263;
        }
        for (String token : MPEG4_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.MPEG4;
        }
        for (String token : AAC_TYPES) {
            if (!name.contains(token)) continue;
            return CodecType.AAC;
        }
        return null;
    }

    static {
        try {
            mediaCodecListClass = Class.forName("android.media.MediaCodecList");
            getCodecInfoAtMethod = mediaCodecListClass.getMethod("getCodecInfoAt", Integer.TYPE);
            mediaCodecInfoClass = Class.forName("android.media.MediaCodecInfo");
            getNameMethod = mediaCodecInfoClass.getMethod("getName", new Class[0]);
            isEncoderMethod = mediaCodecInfoClass.getMethod("isEncoder", new Class[0]);
            getSupportedTypesMethod = mediaCodecInfoClass.getMethod("getSupportedTypes", new Class[0]);
            getCapabilitiesForTypeMethod = mediaCodecInfoClass.getMethod("getCapabilitiesForType", String.class);
            codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            colorFormatsField = codecCapabilitiesClass.getField("colorFormats");
            profileLevelsField = codecCapabilitiesClass.getField("profileLevels");
            for (Field f : codecCapabilitiesClass.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getName().startsWith(COLOR_FORMAT_PREFIX)) continue;
                mColorFormatValues.put(f.getInt(null), (Object)f.getName());
            }
            Class<?> codecProfileLevelClass = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            for (Field f : codecProfileLevelClass.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                if (f.getName().startsWith("AVCLevel")) {
                    mAVCLevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("AVCProfile")) {
                    mAVCProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("H263Level")) {
                    mH263LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("H263Profile")) {
                    mH263ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("MPEG4Level")) {
                    mMPEG4LevelValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (f.getName().startsWith("MPEG4Profile")) {
                    mMPEG4ProfileValues.put(f.getInt(null), (Object)f.getName());
                    continue;
                }
                if (!f.getName().startsWith("AAC")) continue;
                mAACProfileValues.put(f.getInt(null), (Object)f.getName());
            }
            profileField = codecProfileLevelClass.getField("profile");
            levelField = codecProfileLevelClass.getField("level");
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private static enum CodecType {
        AVC,
        H263,
        MPEG4,
        AAC;

    }
}

