/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.acra.ACRA;
import org.acra.CrashReportFileNameParser;
import org.acra.CrashReportFinder;
import org.acra.CrashReportPersister;
import org.acra.collector.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;

final class SendWorker
extends Thread {
    private final Context context;
    private final boolean sendOnlySilentReports;
    private final boolean approvePendingReports;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final List<ReportSender> reportSenders;

    public SendWorker(Context context, List<ReportSender> reportSenders, boolean sendOnlySilentReports, boolean approvePendingReports) {
        this.context = context;
        this.reportSenders = reportSenders;
        this.sendOnlySilentReports = sendOnlySilentReports;
        this.approvePendingReports = approvePendingReports;
    }

    @Override
    public void run() {
        if (this.approvePendingReports) {
            this.approvePendingReports();
        }
        this.checkAndSendReports(this.context, this.sendOnlySilentReports);
    }

    private void approvePendingReports() {
        String[] reportFileNames;
        Log.d((String)ACRA.LOG_TAG, (String)"Mark all pending reports as approved.");
        CrashReportFinder reportFinder = new CrashReportFinder(this.context);
        for (String reportFileName : reportFileNames = reportFinder.getCrashReportFiles()) {
            if (this.fileNameParser.isApproved(reportFileName)) continue;
            File reportFile = new File(this.context.getFilesDir(), reportFileName);
            String newName = reportFileName.replace(".stacktrace", "-approved.stacktrace");
            File newFile = new File(this.context.getFilesDir(), newName);
            if (reportFile.renameTo(newFile)) continue;
            Log.e((String)ACRA.LOG_TAG, (String)("Could not rename approved report from " + reportFile + " to " + newFile));
        }
    }

    private void checkAndSendReports(Context context, boolean sendOnlySilentReports) {
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - start");
        CrashReportFinder reportFinder = new CrashReportFinder(context);
        Object[] reportFiles = reportFinder.getCrashReportFiles();
        Arrays.sort(reportFiles);
        int reportsSentCount = 0;
        for (Object curFileName : reportFiles) {
            if (sendOnlySilentReports && !this.fileNameParser.isSilent((String)curFileName)) continue;
            if (reportsSentCount >= 5) break;
            Log.i((String)ACRA.LOG_TAG, (String)("Sending file " + (String)curFileName));
            try {
                CrashReportPersister persister = new CrashReportPersister(context);
                CrashReportData previousCrashReport = persister.load((String)curFileName);
                this.sendCrashReport(previousCrashReport);
                this.deleteFile(context, (String)curFileName);
            }
            catch (RuntimeException e) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash reports for " + (String)curFileName), (Throwable)e);
                this.deleteFile(context, (String)curFileName);
                break;
            }
            catch (IOException e) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to load crash report for " + (String)curFileName), (Throwable)e);
                this.deleteFile(context, (String)curFileName);
                break;
            }
            catch (ReportSenderException e) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash report for " + (String)curFileName), (Throwable)e);
                break;
            }
            ++reportsSentCount;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - finish");
    }

    private void sendCrashReport(CrashReportData errorContent) throws ReportSenderException {
        if (!ACRA.isDebuggable() || ACRA.getConfig().sendReportsInDevMode()) {
            boolean sentAtLeastOnce = false;
            for (ReportSender sender : this.reportSenders) {
                try {
                    sender.send(errorContent);
                    sentAtLeastOnce = true;
                }
                catch (ReportSenderException e) {
                    if (!sentAtLeastOnce) {
                        throw e;
                    }
                    Log.w((String)ACRA.LOG_TAG, (String)("ReportSender of class " + sender.getClass().getName() + " failed but other senders completed their task. ACRA will not send this report again."));
                }
            }
        }
    }

    private void deleteFile(Context context, String fileName) {
        boolean deleted = context.deleteFile(fileName);
        if (!deleted) {
            Log.w((String)ACRA.LOG_TAG, (String)("Could not delete error report : " + fileName));
        }
    }
}

