/* Server*/
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>

#include "copy.h"
#include "tcputils.h"

#define BUFFER_LENGTH   128

int main()
{
	int server_sockfd, client_sockfd;
	socklen_t client_len;
	struct sockaddr_in client_address;

    // Open a socket for the server.
    server_sockfd=open_sock(9735);

	while(1)
	{
		char buf[BUFFER_LENGTH];

		int fd;
		int size;

		printf("server waiting\n");
		/* Accept a connection. */
		client_len = sizeof(client_address);
		client_sockfd = accept(server_sockfd, (struct sockaddr *)&client_address, &client_len);

        int res;
		//  Get filename from client
		res = read(client_sockfd, buf, BUFFER_LENGTH);

		printf("Filename from client %s\n", buf);

        size = 0;
        // Open source file
        fd = open(buf,O_RDONLY);

        if (fd < 0)     // File not found
        {
            buf[0] = '0';
            write(client_sockfd, buf, 1);
        }
        else
        {
            buf[0] = '1';
            write(client_sockfd, buf, 1);

            // Start to copy file
            size = copy_file(fd,client_sockfd);


            if( size > 0 )
            {
                printf("write size = %d\n", size);
            }
            else
            {
                perror("size");
            }
        }

        close(fd);

		close(client_sockfd);
	}
}
